KasperskyLab.AddRunner("wsm", function (ns, session)
{
	if (window != window.top)
		return;

	var m_callFunction = null;
	var m_callNumber = 1;

	var m_activatedState = 0;
	var m_activatedStateChangeTimeout;

	function Initialize() {
		session.InitializePlugin(function(activatePlugin, registerMethod, callFunction) {
			m_callFunction = callFunction;
			activatePlugin("wsm", OnPing, OnError);
		});
	}

	function OnPing() {
		return ns.MaxRequestDelay;
	}

	function OnError(e) {
		session.Log("ERR WSM - " + (e.message || e));
	}

	function FireActivateEvent() {
		m_callFunction("wsm.sessionActivated", [document.title, m_callNumber], function()
			{
				if (m_activatedState === 3)
					ProcessDeactivate();
				m_activatedState = 2;
			}, OnError);
		m_callNumber++;
		m_activatedState = 1;
	}

	function FireDeactivateEvent() {
		m_callFunction("wsm.sessionDeactivated", [document.title, m_callNumber], function()
			{
				if (m_activatedState === 1)
					ProcessActivate();
				m_activatedState = 0;
			}, OnError);

		m_callNumber++;
		m_activatedState = 3;
	}

	function ProcessActivate()
	{
		clearTimeout(m_activatedStateChangeTimeout);
		m_activatedStateChangeTimeout = ns.SetTimeout(function()
			{
				if (m_activatedState === 0)
					FireActivateEvent();
				else if (m_activatedState === 3)
					m_activatedState = 1;
			}, 0);
	}

	function ProcessDeactivate()
	{
		clearTimeout(m_activatedStateChangeTimeout);
		m_activatedStateChangeTimeout = ns.SetTimeout(function()
			{
				if (m_activatedState === 2)
					FireDeactivateEvent();
				else if (m_activatedState === 1)
					m_activatedState = 3
			}, 0);
	}

	function OnFocus() {
		if (m_callFunction)
			ProcessActivate();
	}

	function OnBlur() {
		if (m_callFunction && !document.hasFocus())
			ProcessDeactivate();
	}

	Initialize();
	if (document.hasFocus())
	{
		FireActivateEvent();
		ns.AddEventListener(window, "load", 
			function()
			{
				if (!document.hasFocus())
					ProcessDeactivate();
			});
	}

	if (window.addEventListener)
	{
		ns.AddEventListener(window, "focus", OnFocus);
		ns.AddEventListener(window, "blur", OnBlur);
	}
	else
	{
		ns.AddEventListener(document, "focusin", OnFocus);
		ns.AddEventListener(document, "focusout", OnBlur);
	}

	ns.AddEventListener(window, "beforeunload", function()
		{
			clearTimeout(m_activatedStateChangeTimeout);
			m_activatedStateChangeTimeout = null;
			m_callFunction = null;
		});
});
